(*| 22:36 21/01/1992 *)
UNIT GXEDIT;

{COMPILE WITH TURBO 6.0 or later for inline assembler support}

INTERFACE

PROCEDURE Edit_Commands;

IMPLEMENTATION

USES Dos,Crt,GXCommon;

CONST
  Video_Intr = $10;
  Dos_Intr   = $21;
  Mouse_Intr = $33;

VAR
  ZoomFactor: INTEGER;
  ImageX,ImageY,TopX,TopY,XNow,YNow: INTEGER;
  LightIndex,LightVal,DarkIndex,DarkVal,MidVal,DarkF,LightF: INTEGER;
  MousePresent,MouseOn,InPalette,InMix: BOOLEAN;
  ChosenColour: BYTE;
  ChColBase: INTEGER;
  VideoRAM: ARRAY[0..$FF00] OF BYTE Absolute $A000:0;

PROCEDURE FindDACLevels;
VAR
  I,R: INTEGER;
BEGIN
  DarkVal:=190;
  LightVal:=0;
  I:=0;
  REPEAT
    R:=DacBuffer[I] + DacBuffer[I+1] + DacBuffer[I+2];
    IF R > LightVal THEN BEGIN
      LightVal := R;
      LightIndex := I DIV 3;
    END;
    IF R < DarkVal THEN BEGIN
      DarkVal := R;
      DarkIndex := I DIV 3;
    END;
    I:=I+3;
    IF I = $30 THEN BEGIN
      LightF := LightIndex;
      DarkF := DarkIndex;
    END;
  UNTIL I > $2FF;
  MidVal := (LightVal + DarkVal) DIV 2;
END;  { FindDACLevels }

FUNCTION MouseFound: BOOLEAN;
VAR
  Regs: Registers;
BEGIN
  WITH Regs DO BEGIN
    AX := 0;
    Intr(Mouse_Intr,Regs);
    MouseFound := AX <> 0;
  END;
END;  { MouseFound }

PROCEDURE SetMouseCursor;
VAR
  Regs: Registers;
BEGIN
  WITH Regs DO BEGIN
    AX := 4;
    CX := (XNow - 1) SHL 1;
    DX := YNow;
    Intr(Mouse_Intr,Regs);
  END;
END;  { SetMouseCursor }

PROCEDURE ToggleMouse;
VAR
  Regs: Registers;
BEGIN
  WITH Regs DO IF MouseOn THEN BEGIN
    AX := 2;
    Intr(Mouse_Intr,Regs);
    MouseOn := FALSE;
  END ELSE BEGIN
    SetMouseCursor;
    AX := 1;
    Intr(Mouse_Intr,Regs);
    MouseOn := TRUE;
  END;
END;  { ToggleMouse }

PROCEDURE SetXNowYNow;
BEGIN
  XNow := (ImageX - TopX) * ZoomFactor;
  YNow := (ImageY - TopY) * ZoomFactor;
END;  { SetXNowYNow }

PROCEDURE SetTopXTopY;
VAR
  XMax,YMax: INTEGER;
BEGIN
  IF ZoomFactor = 1 THEN BEGIN
    TopX := 0;
    TopY := 0;
  END ELSE BEGIN
    TopX := ImageX - (Screen_Width DIV (2*ZoomFactor));
    IF TopX < 0 THEN
      TopX := 0;
    TopY := ImageY - (Screen_Height DIV (2* ZoomFactor));
    IF TopY < 0 THEN
      TopY := 0;
    YMax := Screen_Height - (Screen_Height DIV ZoomFactor);
    IF TopY > YMax THEN
      TopY := YMax;
  END;
  SetXNowYNow;
END;  { SetTopXTopY }

PROCEDURE ShowCursor(CursorX,CursorY: INTEGER);
LABEL
  FirstVert,NextVert;
VAR
  CursorPos: WORD;
BEGIN
  IF NOT MouseOn THEN BEGIN
    CursorPos := (CursorY * Screen_Width) + CursorX;
    ASM
      MOV  AX,0A000H
      MOV  ES,AX
      MOV  DI,CursorPos;
      MOV  AL,ES:[DI]
      PUSH AX
      PUSH DI
      CLD
      SUB  DI,8
      MOV  AX,LightIndex;
      MOV  AH,AL
      MOV  CX,8
      REP  STOSW
      POP  DI
      PUSH DI
      MOV  DX,Screen_Width
      MOV  CX,7
FirstVert:
      SUB  DI,DX
      LOOP FirstVert
      MOV  CX,16
      DEC  DX
NextVert:
      STOSB
      ADD  DI,DX
      LOOP NextVert
      POP  DI
      POP  AX
      STOSB
    END;
  END;
END;  { ShowCursor }

PROCEDURE SetCursor;
BEGIN
  ShowCursor(XNow,YNow);
  IF MouseOn THEN
    SetMouseCursor;
END;  { SetCursor }

PROCEDURE ShowPalette;
LABEL
  NextVert,OldVert,NextHoriz;
BEGIN
  ASM
    PUSH DS
    MOV  AX,0A000H
    MOV  ES,AX
    MOV  DS,AX
    SUB  AX,AX
    MOV  DI,AX
    MOV  CX,8
NextVert:
    PUSH CX
    MOV  CX,32
    MOV  SI,DI
NextHoriz:
    PUSH CX
    MOV  CX,10
    REP  STOSB
    INC  AL
    POP  CX
    LOOP NextHoriz
    MOV  BX,AX
    MOV  CX,9
OldVert:
    PUSH CX
    MOV  CX,160
    REP  MOVSW
    POP  CX
    LOOP OldVert
    MOV  AX,BX
    POP  CX
    LOOP NextVert
    POP  DS
  END;
  InPalette := TRUE;
END;  { ShowPalette }

PROCEDURE MoveData(VAR P);
LABEL
  NextByte,NextLine,RepeatLine;
VAR
  BufferOffset,POfs,PSeg: WORD;
  Regs: Registers;
BEGIN
  IF MouseOn THEN
    ToggleMouse;
  BufferOffset := (TopY * Screen_Width) + TopX;
  IF ZoomFactor < 2 THEN
    POfs := Ofs(P)
  ELSE
    POfs := Ofs(P) + BufferOffset;
  PSeg := Seg(P) + (POfs SHR 4);
  POfs := POfs AND $000F;
  IF ZoomFactor < 2 THEN
    ASM
      CLD
      MOV  CX,0FFFFH
      MOV  DI,0
      MOV  SI,POfs
      MOV  AX,0A000H
      MOV  ES,AX
      PUSH DS
      MOV  DS,PSeg
      REP  MOVSB
      POP  DS
    END
  ELSE ASM
    CLD
    MOV  DI,0
    MOV  SI,POfs
    MOV  BX,ZoomFactor
    MOV  DX,Screen_Width
    MOV  AX,0A000H
    MOV  ES,AX
    PUSH DS
    MOV  DS,PSeg
    MOV  CX,Screen_Height
NextLine:
    PUSH CX
    PUSH SI
    PUSH DX
    PUSH DI
NextByte:
    MOV  CX,BX          {ZoomFactor}
    LODSB
    REP  STOSB
    SUB  DX,BX          {,ZoomFactor}
    JA   NextByte
    POP  DI
    POP  DX             {Screen_Width}
    ADD  DI,DX          {Screen_Width}
    MOV  CX,BX
    DEC  CX
RepeatLine:
    PUSH CX
    PUSH DS
    MOV  AX,ES
    MOV  DS,AX
    MOV  SI,DI
    SUB  SI,DX          {Screen_Width}
    MOV  CX,DX          {Screen_Width}
    SHR  CX,1
    REP  MOVSW
    POP  DS
    POP  CX
    LOOP RepeatLine

    POP  SI
    ADD  SI,DX          {Screen_Width}
    POP  CX
    SUB  CX,BX          {ZoomFactor}
    JA   NextLine
    POP  DS
  END;
  IF MousePresent AND NOT MouseOn THEN BEGIN
    ToggleMouse;
  END;
END;  { MoveData }

PROCEDURE ChangePixel;
VAR
  ImagePos: WORD;
BEGIN
  ImagePos := (ImageY * Screen_Width) + ImageX;
  IF ImagePos < $8000 THEN
    VBuf1^[ImagePos] := ChosenColour
  ELSE
    VBuf2^[ImagePos - $8000] := ChosenColour;
  IF ZoomFactor = 1 THEN
    VideoRam[ImagePos] := ChosenColour
  ELSE
    MoveData(VBuf1^);
END;  { ChangePixel }

PROCEDURE MoveImageX(Delta: INTEGER);
VAR
  NewX: INTEGER;
BEGIN
  NewX := ImageX + Delta;
  IF (NewX < TopX) OR ((NewX - TopX) * ZoomFactor > Screen_Width) THEN
    SetTopXTopY;
  MoveData(VBuf1^);
  IF InPalette THEN
    ShowPalette;
  ImageX := NewX;
  SetXNowYNow;
  SetCursor;
END;  { MoveImageX }

PROCEDURE MoveImageY(Delta: INTEGER);
VAR
  NewY: INTEGER;
BEGIN
  NewY := ImageY + Delta;
  IF (NewY < TopY) OR ((NewY - TopY) * ZoomFactor > Screen_Height) THEN
    SetTopXTopY;
  MoveData(VBuf1^);
  IF InPalette THEN
    ShowPalette;
  ImageY := NewY;
  SetXNowYNow;
  SetCursor;
END;  { MoveImageY }

PROCEDURE EraseScreen;
BEGIN
  ASM
    MOV  AX,0A000H
    MOV  DI,0
    MOV  ES,AX
    MOV  AX,DarkIndex
    MOV  AH,AL
    MOV  CX,08000H
    REP  STOSW
  END;
END;  { EraseScreen }

PROCEDURE EditHelp;
CONST
  CR = #$0D;
  LF = #$0A;
  HelpText : STRING =
    'Fine Cursor  <Left>,<Right>,<Up>,<Down>.' +
    'Fast Cursor  <Ctrl><Left> <Crtl><Right> ' +
    '             <PgUp>       <PgDn>        ' +
    'Zoom Z,  UnZoom U,  Palette P,  Cursor C' +
    'Restore R,  Full Screen  <Home> or <End>' +
    'Erase E, <Del> Copy, <Ins> Paste        ';
VAR
  POfs,PSeg,Len,Attr: WORD;
BEGIN
  Attr := LightF + (DarkF SHR 4);
  PSeg := Seg(HelpText);
  POfs := Ofs(HelpText)+1;
  Len := Length(HelpText);
  ASM
    MOV  AX,0A000H
    MOV  ES,AX
    MOV  CX,2800H
    SUB  AX,AX
    MOV  DI,AX
    REP  STOSW
    MOV  BX,Attr
    MOV  CX,Len
    MOV  AX,PSeg
    MOV  ES,AX
    MOV  AX,POfs
    PUSH BP
    MOV  BP,AX
    MOV  DX,0
    MOV  AX,$1300
    INT  Video_Intr
    POP  BP
  END;
END;  { EditHelp }

PROCEDURE GetPixel;
VAR
  PalettePos: WORD;
BEGIN
  PalettePos := XNow + (YNow * Screen_Width);
  ChosenColour := VideoRam[PalettePos];
END;  { GetPixel }

PROCEDURE MixPalette;
VAR
  I: INTEGER;

  PROCEDURE ThisDacBox;
  LABEL
    NextLine;
  BEGIN
    ASM
      MOV  AX, 0A000H
      MOV  ES, AX
      MOV  DI, 32000
      MOV  CX, 68
      MOV  AX, LightIndex
      MOV  BX, DarkIndex
      MOV  BH, AL
NextLine:
      PUSH DI
      PUSH CX
      MOV  AL, BL
      STOSB
      MOV  AL, BH
      MOV  CX, 32
      REP  STOSB
      MOV  AL, BL
      STOSB
      POP  CX
      POP  DI
      ADD  DI, Screen_Width
      LOOP NextLine
      SUB  DI, Screen_Width
      MOV  CX, 34
      REP  STOSB
      MOV  DI, 32000
      MOV  CX, 34
      REP  STOSB
    END;
  END;

  PROCEDURE ShowThisDac;
  LABEL
    NextLine;
  VAR
    RDac,GDac,BDac: BYTE;
  BEGIN
    RDac := DacBuffer[ChColBase];
    GDac := DacBuffer[ChColBase+1];
    BDac := DacBuffer[ChColBase+2];
    ASM
      MOV  AX, 0A000H
      MOV  ES, AX
      MOV  DI, 32642
      MOV  CX, 64
      MOV  AX, LightIndex
      MOV  BX, DarkIndex
      MOV  BH, AL
      SHR  AL, 1
NextLine:
      PUSH DI
      MOV  DL, CL
      PUSH CX
      MOV  CX, 10
      MOV  AL, BH
      CMP  DL, RDac
      JB   @1
      MOV  AL, BL
@1:
      REP  STOSB
      MOV  CX, 10
      MOV  AL, BH
      CMP  DL, GDac
      JB   @2
      MOV  AL, BL
@2:
      REP  STOSB
      MOV  CX, 10
      MOV  AL, BH
      CMP  DL, BDac
      JB   @3
      MOV  AL, BL
@3:
      REP  STOSB
      POP  CX
      POP  DI
      ADD  DI, Screen_Width
      LOOP NextLine
    END;
  END;

BEGIN
  ChColBase := ChosenColour * 3;
  InMix := TRUE;
  ThisDacBox;
  ShowThisDac;
END;  { MixPalette }

PROCEDURE ChangeDac(Col,Change: INTEGER);
VAR
  Regs: Registers;
BEGIN
  IF InMix THEN WITH Regs DO BEGIN
    DacBuffer[ChColBase + Col] := DacBuffer[ChColBase + Col] + Change;
    IF  DacBuffer[ChColBase + Col] > 63 THEN BEGIN
      IF (Change AND $80) = 0 THEN
        DacBuffer[ChColBase + Col] := 63
      ELSE
        DacBuffer[ChColBase + Col] := 0;
    END;
    AX := $1012;
(*
    BX := ChosenColour;
    CX := 1;
*)
    BX := 0;
    CX := $100;

    DX := Ofs(DacBuffer);
    ES := Seg(DacBuffer);
    Intr(Video_Intr,Regs);
    MixPalette;
  END;
END;  { ChangeDac }

PROCEDURE GetMousePosition;
VAR
  Regs: Registers;
  PalettePos: WORD;
BEGIN
  WITH Regs DO BEGIN
    AX := 3;
    Intr(Mouse_Intr,Regs);
    IF InPalette THEN
      PalettePos := (DX * Screen_Width) + (CX SHR 1) + 1
    ELSE IF ZoomFactor = 1 THEN BEGIN
      ImageX := (CX SHR 1) + 1;
      ImageY := DX;
    END ELSE BEGIN
      XNow := (CX SHR 1) + 1;
      ImageX := TopX + (XNow DIV ZoomFactor);
      YNow := DX;
      ImageY := TopY + (YNow DIV ZoomFactor);
    END;
    IF (BX AND 1) > 0 THEN BEGIN   {left button pressed}
      IF NOT InPalette THEN
        ChangePixel
      ELSE BEGIN
        ChosenColour := VideoRam[PalettePos];
        IF InMix THEN
          MixPalette;
      END;
    END;
    IF InPalette THEN BEGIN
      AX := 5;
      BX := 1;  {right button}
      Intr(Mouse_Intr,Regs);
      IF BX > 0 THEN BEGIN
        AX := 2;
        Intr(Mouse_Intr,Regs);
        InPalette := FALSE;
        MoveData(VBuf1^);
        AX := 1;
        Intr(Mouse_Intr,Regs);
        AX := 6;
        BX := 1;
        Intr(Mouse_Intr,Regs);
      END;
    END ELSE BEGIN
      AX := 6;
      BX := 1;
      Intr(Mouse_Intr,Regs);
      IF BX > 0 THEN BEGIN
        AX := 2;
        Intr(Mouse_Intr,Regs);
        ShowPalette;
        AX := 5;
        BX := 1;
        Intr(Mouse_Intr,Regs);
        AX := 1;
        Intr(Mouse_Intr,Regs);
      END;
    END;
  END;
END;  { GetMousePosition }

PROCEDURE Edit_Commands;
CONST
  DefaultCursorPos = (Screen_Width DIV 2)
                      + ((Screen_Height DIV 2) * Screen_Width);
VAR
  Regs: Registers;
  C1,C2: CHAR;
  Done: BOOLEAN;
BEGIN
  FindDACLevels;
  Done := FALSE;
  MouseOn := FALSE;
  InPalette := FALSE;
  InMix := FALSE;
  ZoomFactor := 1;
  ImageX := Screen_Width DIV 2;
  ImageY := Screen_Height DIV 2;
  SetTopXTopY;
  WITH Regs DO BEGIN
    AX := $0013;
    Intr(Video_Intr,Regs);
    AX := $1012;
    BX := 0;
    CX := $100;
    DX := Ofs(DacBuffer);
    ES := Seg(DacBuffer);
    Intr(Video_Intr,Regs);
    MoveData(VBuf1^);
    IF MousePresent AND NOT MouseOn THEN
      ToggleMouse;
    REPEAT
      IF MouseOn AND NOT KeyPressed THEN
        GetMousePosition
      ELSE BEGIN
        C1 := ReadKey;
        IF C1 = #0 THEN BEGIN
          C2 := ReadKey;
          Case ORD(C2) OF
            59 : EditHelp;                              { F1 }
            71 : BEGIN                                  { Home }
                   ImageX := Screen_Width DIV 2;
                   ImageY := Screen_Height DIV 2;
                   ZoomFactor := 1;
                   SetTopXTopY;
                   InPalette := FALSE;
                   MoveData(VBuf1^);
                   ShowCursor(ImageX,ImageY);
                 END;
            72 : MoveImageY(-1);                        { CUp }
            73 : MoveImageY(-10);                       { PgUp }
            75 : MoveImageX(-1);                        { CLeft }
            77 : MoveImageX(1);                         { CRight }
            79 : BEGIN                                  { End }
                   ZoomFactor := 1;
                   SetTopXTopY;
                   InPalette := FALSE;
                   MoveData(VBuf1^);
                   ShowCursor(ImageX,ImageY);
                 END;
            80 : MoveImageY(1);                         { CDown }
            81 : MoveImageY(10);                        { PgDn }
            82 : ChangePixel;                           { Ins }
            83 : BEGIN                                  { Del }
                   InPalette := False;
                   GetPixel;
                   IF ZoomFactor =  1 THEN
                     MoveData(VBuf1^);
                 END;
            115: MoveImageX(-10);                        { Ctrl CLeft }
            116: MoveImageX(10);                         { Ctrl CRight }
          END;
        END ELSE Case UpCase(C1) OF
          #27 : Done := TRUE;
          '1' : ChangeDac(0,1);
          '2' : ChangeDac(1,1);
          '3' : ChangeDac(2,1);
          '!' : ChangeDac(0,-1);
          '"' : ChangeDac(1,-1);
          '' : ChangeDac(2,-1);
          '#' : ChangeDac(2,-1);
          'C' : ShowCursor(XNow,YNow);
          'E' : EraseScreen;
          'P' : ShowPalette;
          'R' : BEGIN
                  InPalette := FALSE;
                  MoveData(VBuf1^);
                END;
          'M' : IF InPalette THEN
                  MixPalette
                ELSE BEGIN
                  ToggleMouse;
                  MousePresent := MouseOn;
                END;
          'U' : IF ZoomFactor > 1 THEN BEGIN
                    ZoomFactor := ZoomFactor SHR 1;
                  SetTopXTopY;
                  InPalette := FALSE;
                  MoveData(VBuf1^);
                  SetCursor;
                END;
          'Z' : IF ZoomFactor < 64 THEN BEGIN
                  ZoomFactor := ZoomFactor SHL 1;
                  SetTopXTopY;
                  InPalette := FALSE;
                  MoveData(VBuf1^);
                  SetCursor;
                END;
        END;
      END;
      IF NOT InPalette THEN
        InMix := FALSE;
    UNTIL Done;
    IF MouseOn THEN BEGIN
      AX := 2;
      Intr(Mouse_Intr,Regs);
      MouseOn := FALSE;
    END;
    AX := $0003;
    Intr(Video_Intr,Regs);
  END;
END;  { Edit_Commands }

BEGIN
  MousePresent := MouseFound;
END.
